;Listing 1 - POWER.ASM

   section  text,code            ;for the PHXASS assembler
start:
   move.l   sp,stack             ;save the Stack Pointer
number_of_times
   moveq    #6,d1                ;# of times to blink
power_off
   ori.b    #%00000010,$bfe001   ;set bit1
   moveq    #0,d0                ;clear d0
delay1
   subq.w   #1,d0                ;decrease d0 by 1
   bne      delay1               ;branch if not 0
delay2
   subq.w   #1,d0
   bne      delay2
power_on
   andi.b   #%11111101,$bfe001   ;clear bit1
   moveq    #0,d0                ;reset delay counter
delay3
   subq.w   #1,d0
   bne      delay3
delay4
   subq.w   #1,d0
   bne      delay4

   subq.w   #1,d1                ;one less blink
   bne      power_off            ;repeat if not 0
   movea.l  stack,sp             ;restore the Stack Pointer
   rts                           ;return to CLI
   even                          ;force to an even address
stack dc.l  0                    ;reserve a long word
   end                           ;end of program


